/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.momlove.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import committee.nova.momlove.MomLove;
import committee.nova.momlove.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Configuration load() {
        Path configPath;
        Configuration config = new Configuration();
        if (!MomLove.getConfigFolder().toFile().isDirectory()) {
            try {
                Files.createDirectories(MomLove.getConfigFolder(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((configPath = MomLove.getConfigFolder().resolve(config.getConfigName() + ".json")).toFile().isFile()) {
            try {
                config = (Configuration)GSON.fromJson(FileUtils.readFileToString((File)configPath.toFile(), (Charset)StandardCharsets.UTF_8), Configuration.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileUtils.write((File)configPath.toFile(), (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public static void save(Configuration config) {
        if (!MomLove.getConfigFolder().toFile().isDirectory()) {
            try {
                Files.createDirectories(MomLove.getConfigFolder(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Path configPath = MomLove.getConfigFolder().resolve(config.getConfigName() + ".json");
        try {
            FileUtils.write((File)configPath.toFile(), (CharSequence)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void onChange() {
        ConfigHandler.save(MomLove.getConfig());
        MomLove.setConfig(ConfigHandler.load());
    }
}

